<?php

/** Register Globals for Shortcode API */
$GLOBALS['cloudfw_registered_shortcodes'] = array();
$GLOBALS['cloudfw_pre_do_shortcodes'] = array();

/**
 *	CloudFw Shortcodes API
 *
 *	@since 3.0
 */
class CloudFw_Shortcodes {
	public static  $groups;
	public static  $schemes;
	private static $shortcode_number = 0;
	private static $shortcode_number_in_group = array();

	//public static  $composer_element_map;
	public 		   $do_before   = true;
	public 		   $is_composer = false;
	public 		   $is_widget   = false;
	public 		   $widget;
	public static  $data;
	public static  $composer_groups;
	public static  $composer_schemes;
	public static  $composer_schemes_data;
	private static $composer_number = 0;
	private static $composer_number_in_group = array();

	public static  $shortcode_vars;

	/**
	 *	Register
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	function __construct() {}

	/**
	 *	Register
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	public function _register( $class = NULL, $shortcode = NULL, $group = NULL, $spec_line = NULL ) {
		$called_class = $this->get_called_class();

		if ( is_admin() ) {
			if ( class_exists( $called_class . '_Admin' ) )
				$called_class .= '_Admin';
		}

		if ( !class_exists($called_class) ) {
			return;
		}

		if ( in_array($called_class, $GLOBALS['cloudfw_registered_shortcodes'] ) )
			return;
		else
			$GLOBALS['cloudfw_registered_shortcodes'][] = $called_class;

		if ( is_admin() ) {

			/** Check if the shortcode has admin scheme */
			if ( method_exists($this, 'scheme') ){

				if ( $group ) {

					self::$shortcode_number++;
					$group_id = $this->group_id($group);

					if ( !isset( self::$shortcode_number_in_group[ $group_id ] ) )
						self::$shortcode_number_in_group[ $group_id ] = 0;

					if ( isset( $spec_line ) )
						self::$shortcode_number_in_group[ $group_id ] = $spec_line;

					$line = self::$shortcode_number_in_group[ $group_id ];

					while ( isset( self::$schemes[ $group_id ][ 'data' ][ $line ] ) ){
						self::$shortcode_number_in_group[ $group_id ]++;
						$line = self::$shortcode_number_in_group[ $group_id ];
					}

					self::$schemes[ $group_id ][ 'data' ][ $line ] = $this->data_prepare( $this->scheme() );

				}

			}


			/** Add the shortcode to the composer list */
			$composer_settings = $this->composer();
			if ( $composer_settings['composer'] === true ) {

				if ( method_exists($this, 'composer_scheme') )
					$composer_scheme = $this->composer_scheme();
				elseif ( method_exists($this, 'scheme') )
					$composer_scheme = $this->scheme();
				else
					$composer_scheme = false;


				/** Check Scheme */
				if ( $composer_scheme ) {

					self::$composer_number++;
					$composer_group_id = $this->composer_group_id( $composer_settings['group'] );

					if ( !isset( self::$composer_number_in_group[ $composer_group_id ] ) )
						self::$composer_number_in_group[ $composer_group_id ] = 0;

					if ( isset( $composer_settings['line'] ) )
						self::$composer_number_in_group[ $composer_group_id ] = $composer_settings['line'];

					$composer_line = self::$composer_number_in_group[ $composer_group_id ];

					while ( isset( self::$composer_schemes[ $composer_group_id ][ 'data' ][ $composer_line ] ) ){
						self::$composer_number_in_group[ $composer_group_id ]++;
						$composer_line = self::$composer_number_in_group[ $composer_group_id ];
					}

					//self::$composer_schemes[ $composer_group_id ][ 'data' ][ $composer_line ] = $class;
					self::$composer_schemes[ $composer_group_id ][ 'data' ][ $composer_line ] = $this->composer_title_prepare( $class, $composer_scheme );

					if ( method_exists($this, 'scheme') )
						self::$composer_schemes_data[ $composer_group_id ][ 'data' ][ $composer_line ] = $this->composer_data_prepare( $class, $this->scheme() );

					unset( $composer_scheme );

				}

			}

			/** Add skinable options for the shortcode */
			if ( method_exists($this, 'skin_scheme') && function_exists('cloudfw_add_skin_scheme') )
				add_filter( 'cloudfw_schemes_skin', array( &$this, 'skin_scheme' ), 10, 2 );

			if ( method_exists($this, 'typo_scheme') )
				add_filter( 'cloudfw_typo_scheme', array( &$this, 'typo_scheme' ), 10, 3 );

		} else {
			global $cloudfw_pre_do_shortcodes;

			/** Detect register method for the shortcode */
			if ( method_exists($this, 'register') ) {
				$shortcodes = $this->register();
				foreach ($shortcodes as $shortcode) {
					add_shortcode( $shortcode, array( &$this, 'shortcode' ) );
					if ( $this->do_before ) {
						$cloudfw_pre_do_shortcodes[] = $shortcode;
					}
				}
			}
			elseif ( method_exists($this, 'add') ) {
				$shortcodes = $this->add();
				foreach ($shortcodes as $shortcode => $callback) {
					add_shortcode( $shortcode, $callback );
					if ( $this->do_before ) {
						$cloudfw_pre_do_shortcodes[] = $shortcode;
					}
				}
			}
			elseif ( $shortcode ) {
				add_shortcode( $shortcode, array( &$this, 'shortcode' ) );
				if ( $this->do_before ) {
					$cloudfw_pre_do_shortcodes[] = $shortcode;
				}
			}

		}

		if ( method_exists($this, 'skin_map') ) {
			add_filter( 'cloudfw_skin_map_object', array( &$this, 'skin_map' ) );
		}

		if ( method_exists($this, 'typo_map') ) {
			add_filter( 'cloudfw_typo_map_object', array( &$this, 'typo_map' ) );
		}

	}

	/**
	 *	Get Scheme
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	public function get_scheme() {
		$schemes = self::$schemes;
		$groups  = self::$groups;
		$groups  = $this->group_prepare( $groups );
		return cloudfw_array_merge( $groups,  $schemes );
	}

	/**
	 *	Register Group
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	public function group_register( $key, $line, $data ) {
		$data[ 'type' ]   = 'shortcode:group';
		$data[ 'number' ] = $line;
		$data[ 'id' ]  	  = $key;
		return self::$groups[ $key ] = $data;
	}

	/**
	 *	Detect Group ID
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	private function group_id( $key ) {
		$groups = self::$groups;
		return isset($groups[ $key ][ 'number' ]) ? $groups[ $key ][ 'number' ] : NULL;
	}

	/**
	 *	Prepare Group
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	private function group_prepare() {
		$groups_raw = self::$groups;
		$groups = array();

		foreach ((array) $groups_raw as $key => $data)
			$groups[ $data['number'] ] = $data;

		return $groups;

	}

	/**
	 *	Prepare Data
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	private function data_prepare( $data ) {
		$data['type'] = 'shortcode:sub';
		$data['id']   = 'sc_' . self::$shortcode_number;
		return (array) $data;

	}

	/**
	 *	Composer
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	public function composer(){
		return array( 'composer' => false );
	}

	/**
	 *	Get Composer Scheme
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	public function get_composer_scheme() {
		$schemes = self::$composer_schemes;
		$composer_groups  = self::$composer_groups;
		$composer_groups  = $this->composer_group_prepare( $composer_groups );
		return cloudfw_array_merge( $composer_groups,  $schemes );
	}

	/**
	 *	Get Composer Data
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	public function get_composer_data() {
		$schemes = self::$composer_schemes_data;
		$composer_groups  = self::$composer_groups;
		$composer_groups  = $this->composer_group_prepare( $composer_groups );
		return cloudfw_array_merge( $composer_groups,  $schemes );
	}


	/**
	 *	Register Composer Group
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	public function composer_group_register( $key, $line, $data ) {
		$data[ 'type' ]   = 'composer:group';
		$data[ 'number' ] = $line;
		$data[ 'id' ]  	  = $key;
		return self::$composer_groups[ $key ] = $data;
	}

	/**
	 *	Detect Composer Group ID
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	private function composer_group_id( $key ) {
		$composer_groups = self::$composer_groups;
		return $composer_groups[ $key ][ 'number' ];
	}

	/**
	 *	Prepare Composer Group
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	private function composer_group_prepare() {
		$composer_groups_raw = self::$composer_groups;
		$composer_groups = array();

		foreach ((array) $composer_groups_raw as $key => $data)
			$composer_groups[ $data['number'] ] = $data;

		return $composer_groups;

	}

	/**
	 *	Prepare Composer Titles
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	public function composer_title_prepare( $class, $data ) {
		$title = array();
		$title['composer_id'] = $class;
		$title['type'] 		= 'composer:sub';
		$title['id']        = 'composer-' . self::$composer_number;
		$title['number']    = self::$composer_number;
		$title['composer']  = $this->composer();


		return (array) $title;
	}

	/**
	 *	Prepare Composer Data
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	public function composer_data_prepare( $class, $data ) {
		$data['composer_id'] = $class;
		$data['type']      = 'composer:sub';
		$data['id']        = 'composer-' . self::$composer_number;
		$data['number']    = self::$composer_number;
		$data['composer']  = $this->composer();

		return (array) $data;
	}

	/**
	 *	Set Composer Data
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	public function set_data( $data ){
		self::$data = $data;
	}

	/**
	 *	Get Value
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	public function get_value( $key, $default = '' ){
		if ( $this->is_composer || $this->is_widget ) {
			if ( isset(self::$data[ $key ]) && (!empty( self::$data[ $key ] ) || self::$data[ $key ] === '0' || self::$data[ $key ] === 0 ))
				return self::$data[ $key ];
			else
				return $default;

		}
		else
			return $default;
	}

	/**
	 *	Get Filed Name
	 *
	 *	@package CloudFw
	 *	@since 3.0
	 */
	public function get_field_name( $key ){
		if ( $this->is_widget ) {
			if ( $this->widget )
				return $this->widget->get_field_name($key);
			else
				return $key;

		} else {
			return $key;
		}
	}

	/**
	 *	Load Scheme File
	 *
	 *	@package CloudFw
	 *	@since 3.1
	 */
	public function load_scheme( $filepath ) {
		return is_admin() ? array(
			array(
				'type'		=>	'scheme',
				'source'	=>	$filepath,
				'this'		=>	$this
			)
		) : NULL;
	}
}