<?php
/*
 * Plugin Name: Hidden Content
 * Plugin URI: http://wptation.com
 * Description:
 * Version: 1.0
 * Author: Orkun Gürsel
 * Author URI: http://wptation.com
 */
cloudfw_register_shortcode( 'CloudFw_Composer_Hidden_Content', 'hidden_content', 'columns', 25  );
if ( ! class_exists('CloudFw_Composer_Hidden_Content') ) {
	class CloudFw_Composer_Hidden_Content extends CloudFw_Shortcodes {

		function get_called_class(){ return get_class($this); }


		/** Add the shortcode to the composer */
		function composer(){
			return array(
				'composer'		=> true,
				'droppable'		=> true,
				'ajax'			=> true,
				'icon'			=> 'html-responsive',
				'group'			=> 'composer_layouts',
				'line'			=> 40,
				'options'		=> array(
					'title'				=> __('Hidden Content','envision-core'),
					'column'			=> '1/1',
					'allow_columns'		=> false,
				)
			);
		}

		/** Run */
		function shortcode( $atts = array(), $content =  NULL, $case = NULL ) {
			extract( shortcode_atts(
				array(
					'on'	=> '',
					'off'	=> '',
				), $atts )
			);

			$on = trim( $on );
			$off = trim( $off );

			if ( empty( $on ) && empty( $off ) ) {
				return '';
			}

			$showit = false; // Set some defaults.

			if ( ! empty( $on ) && ! empty( $off ) ) {
				$showit = strtotime( $on . ' +0000' ) < current_time( 'timestamp' ) && strtotime( $off . ' +0000' ) > current_time( 'timestamp' );
			} elseif ( ! empty( $on ) ) {
				$showit = strtotime( $on . ' +0000' ) < current_time( 'timestamp' );
			} elseif ( ! empty( $off ) ) {
				$showit = strtotime( $off . ' +0000' ) > current_time( 'timestamp' );
			}

			if ( true === $showit ) {
				return $content;
			}

			return '';
		}

		/** Scheme */
		function scheme() {
			return array(
				'title'		=>	__('Hidden Content','envision-core'),
				'script'	=> array(
					'shortcode' 	=> 'hidden_content',
					'tag_close'  	=> true,
					'attributes' 	=> array(
						'on'   => array( 'e' => 'on' ),
  						'off'  => array( 'e' => 'off' ),
					)
				),
				'data'		=>  $this->load_scheme( __FILE__ )
			);

		}

		/** Scheme */
		function composer_scheme() {
			return array(
				'data'		=>	array(
					cloudfw_composer_default_dropped_area()
				)
			);
		}

	}

}