<?php
/*************************
 *	DO NOT EDIT THIS PAGE
 *************************/

/**
 *	CloudFw Variables
 */
$cloudfw_setting_slug = 'CloudFW';
$cloudfw_slider_slug = 'CloudFW_Slider';
$page = isset($_GET["page"]) ? $_GET["page"] : 'CloudFW';
$upload_dir = wp_upload_dir();
$is_child_theme = is_child_theme();

if ( $is_multisite = (defined('MULTISITE')) && (MULTISITE == true) ) {
	global $blog_id;
	$suffix = $blog_id . '/';
} else {
	$suffix = '';
}

if ( ! defined('CHILD_TMP_URL') ) {
	define( 'CHILD_TMP_URL', trailingslashit(get_stylesheet_directory_uri()) );
}

if ( ! defined('CHILD_TMP_PATH') ) {
	define( 'CHILD_TMP_PATH', trailingslashit(get_stylesheet_directory()) );
}

define( 'CLOUDFW_VERSION', '4.0b' );
define( 'CLOUDFW_PAGE', 'admin.php?page='. $page );
define( 'CLOUDFW_WPVERSION', get_bloginfo('version') );

require( TMP_PATH.'includes/theme/theme.configs.php' );

define( 'TMP_ADMIN',  TMP_URL. '/cloudfw' );
define( 'TMP_ADMIN_PATH', TMP_PATH.'cloudfw' );
define( 'TMP_ADMIN_GUI', TMP_URL. '/cloudfw/gui' );

define( 'TMP_LIB',  TMP_URL. '/lib/' );
define( 'TMP_LIB_PATH',  TMP_PATH. 'lib/' );
define( 'TMP_CSS',  TMP_LIB. 'css/' );
define( 'TMP_CSS_PATH',  TMP_LIB_PATH. 'css/' );
define( 'TMP_JS',   TMP_LIB. 'js/' );
define( 'TMP_JS_PATH',  TMP_LIB_PATH. 'js/' );

define( 'TMP_INCLUDES', TMP_PATH.'includes' );
define( 'TMP_LOADERS', TMP_INCLUDES.'/theme' );
define( 'TMP_SLIDERS', TMP_INCLUDES.'/sliders' );
define( 'TMP_SHORTCODES', TMP_INCLUDES.'/shortcodes' );
define( 'TMP_WIDGETS', TMP_INCLUDES.'/widgets' );
define( 'TMP_MODULES', TMP_INCLUDES.'/modules' );
define( 'TMP_DEFAULTS', TMP_INCLUDES.'/defaults' );

define( 'TMP_OPTIONS', TMP_LOADERS.'/options' );
define( 'TMP_VISUAL_OPTIONS', TMP_LOADERS.'/visual' );
define( 'TMP_TYPO_OPTIONS', TMP_LOADERS.'/typo' );

define( 'CLOUDFW_UPLOADDIR',  $upload_dir["basedir"].'/' );
define( 'CLOUDFW_UPLOADDIR_FULL',  $upload_dir["path"].'/' );

define( 'CACHE_DIR',  $upload_dir["url"] . '/' /*. $suffix*/ );
define( 'CACHE_DIR_BASE',  $upload_dir["path"] . '/' );
define( 'CACHE_DIR_PATH',  CACHE_DIR_BASE /*. $suffix*/ );

define( 'SLIDERS_DIR',  TMP_URL.'/includes/sliders/' );
define( 'SLIDERS_DIR_PATH',  TMP_PATH.'includes/sliders/' );

define( 'SLIDER_RESOURCES',  $upload_dir["baseurl"] . '/sliders/' );
define( 'SLIDER_RESOURCES_PATH',  $upload_dir["basedir"] . '/sliders/' );

define( 'SKINS_DIR',  $upload_dir["baseurl"] . '/skins/' );
define( 'SKINS_DIR_PATH',  $upload_dir["basedir"] . '/skins/' );

if ( $is_child_theme ) {
	define( 'FONTS_DIR',  CHILD_TMP_URL.'fontface/' );
	define( 'FONTS_DIR_PATH',  CHILD_TMP_PATH.'fontface/' );
	define( 'ICONS_DIR',  CHILD_TMP_URL.'icons/' );
	define( 'ICONS_DIR_PATH',  CHILD_TMP_PATH.'icons/' );
} else {
	define( 'FONTS_DIR',  TMP_URL.'/resources/fontface/' );
	define( 'FONTS_DIR_PATH',  TMP_PATH.'resources/fontface/' );
	define( 'ICONS_DIR',  TMP_URL.'/resources/icons/' );
	define( 'ICONS_DIR_PATH',  TMP_PATH.'resources/icons/' );
}

define( 'DUMMY_DIR',  TMP_URL.'/resources/dummy/' );
define( 'DUMMY_DIR_PATH',  TMP_PATH.'resources/dummy/' );

define( 'PREPAGES_DIR',  TMP_URL.'/resources/prepages/' );
define( 'PREPAGES_DIR_PATH',  TMP_PATH.'resources/prepages/' );

if ( ! defined('FS_CHMOD_DIR') ) {
	define('FS_CHMOD_DIR', 0755 );
}

if ( ! defined('FS_CHMOD_FILE') ) {
	define('FS_CHMOD_FILE', 0644 );
}

/**
 *	CloudFw Admin Messages
 *
 *	@since 1.0
 *	@version 3.0
 */
function cloudfw_admin_messages( $message_id ) {
	$out = array();

	global $cloudfw_extra_query;
		   $cloudfw_extra_query = array_merge( (array)$_REQUEST, (array)$cloudfw_extra_query );

	switch ($message_id) {

		/**
		 *	General Messages
		 */
		case 999:
			$out = array(
				'msg' 	=> __('The Theme Activated','envision'),
				'key' 	=> 'update'
			); break;
		case 1000:
			$out = array(
				'title' => __('Options Updated','envision'),
				'msg'   => __('All options saved successfuly.','envision'),
				'key'   => 'update'
			); break;
		case 2000:
			$out = array(
				'title' => __('Option Deleted','envision'),
				'msg' 	=> __('Options deleted successfuly.','envision'),
				'key' 	=> 'cancel'
			); break;
		case 2010:
			$out = array(
				'title' => __('Sidebar Settings Saved','envision'),
				'msg' 	=> __('Sidebar settings saved successfuly.','envision'),
				'key' 	=> 'add'
			); break;

		/**
		 *	Errors Messages
		 */
		case 1003:
			$out = array(
				'title' => __('Sorry','envision'),
				'msg' 	=> __('There was an error when saving options.','envision'),
				'key' 	=> 'error'
			); break;
		case 1004:
			$out = array(
				'title' => __('Action Aborted','envision'),
				'msg' 	=> __('Failed nonce check and the action aborted.','envision'),
				'key' 	=> 'error'
			); break;
		case 1005:
			$out = array(
				'title' => __('Action Aborted','envision'),
				'msg' 	=> __('You don\'t have the permission to do that.','envision'),
				'key' 	=> 'error'
			); break;
		case 1006:
			$out = array(
				'title' => __('You are logged out!','envision'),
				'msg' 	=> __('Could not save the data.','envision') . ' <strong><a href="'.wp_login_url().'" target="_blank">' . __('Please log in again.','envision') . '</a></strong>',
				'key' 	=> 'error'
			); break;
		case 1024:
			$out = array(
				'title' => __('Oopss!','envision'),
				'msg' 	=> __('An error occurred when uploading.','envision'),
				'key' 	=> 'cancel'
			); break;
		case 1025:
			$out = array(
				'title' => __('Input Vars Limit Warning','envision'),
				'msg' 	=> sprintf(__('You are approaching the post variable limit imposed by your server configuration. Exceeding this limit may automatically delete the page datas when you save. Please increase your <strong>max_input_vars</strong> directive in php.ini. %s','envision'), '<a target="_blank" href=\''. cloudfw_admin_url('global') .'#troubleshooting\'>'. __('More information','envision') .'</a>'),
				'key' 	=> 'notice'
			); break;
		case 2001:
			$out = array(
				'title' => __('Sorry','envision'),
				'msg' 	=> __('An error has occurred.','envision'),
				'key' 	=> 'cancel'
			); break;
		case 2010:
			$out = array(
				'title' => __('Sorry','envision'),
				'msg' 	=> __('Your refferer cannot Verified.','envision'),
				'key' 	=> 'cancel'
			); break;

		/**
		 *	Slider Messages
		 */
		case 6001:
			$out = array(
				'title' => __('Item Created','envision'),
				'msg' 	=> __('Slider item created successfuly.','envision'),
				'key' 	=> 'add'
			); break;
		case 6002:
			$out = array(
				'title' => __('Slider Updated','envision'),
				'msg' 	=> __('Slider item(s) updated successfuly.','envision'),
				'key' 	=> 'update'
			); break;
		case 6004:
			$out = array(
				'title' => __('Slider Created','envision'),
				'msg' 	=> __('New slider created successfuly.','envision'),
				'key' 	=> 'add'
			); break;
		case 6005:
			$out = array(
				'title' => __('Slider Options Saved','envision'),
				'msg' 	=> '<a href=\"'.$cloudfw_extra_query['this_page'].'&amp;id='. $cloudfw_extra_query['msid'] .'\">'. __('Add a new slider item','envision') .'</a>',
				'key' 	=> 'update'
			); break;
		case 6006:
			$out = array(
				'msg' 	=> __('Slider Duplicated','envision'),
				'key' 	=> 'add'
			); break;
		case 6007:
			$out = array(
				'msg' 	=> __('Slider Imported','envision'),
				'key' 	=> 'add'
			); break;
		case 6008:
			$out = array(
				'title' => __('Sliders Sorted','envision'),
				'msg' 	=> __('Sliders sorted and saved successfuly.','envision'),
				'key' 	=> 'update'
			); break;

		case 9022:
			$out = array(
				'msg' 	=> __('Could not be found any .slider file in the zip file','envision'),
				'key' 	=> 'error'
			); break;

		/**
		 *	Skin Messages
		 */
		case 7001:
			$out = array(
				'msg' 	=> __('New Visual Set Created','envision'),
				'key' 	=> 'add'
			); break;
		case 7002:
			$out = array(
				'msg' 	=> __('Visual Settings Updated','envision'),
				'key' 	=> 'update'
			); break;
		case 7003:
			$out = array(
				'msg' 	=> __('Visual Set Deleted','envision'),
				'key' 	=> 'cancel'
			); break;
		case 7004:
			$out = array(
				'msg' 	=> __('Default Visual Set Changed','envision'),
				'key' 	=> 'update'
			); break;
		case 7005:
			$out = array(
				'msg' 	=> __('Visual Settings Updated and Applied as Default','envision'),
				'key' 	=> 'update'
			); break;
		case 7006:
			$out = array(
				'title' => __('Visual Set Duplicated','envision'),
				'msg' 	=> __('All settings duplicated successfuly.','envision'),
				'key' 	=> 'add'
			); break;
		case 7011:
			$out = array(
				'title' => __('Visual Set Imported','envision'),
				'msg' 	=> __('All settings imported successfuly.','envision'),
				'key' 	=> 'add'
			); break;
		case 7012:
			$out = array(
				'title' => __('Visual Sets Sorted','envision'),
				'msg' 	=> __('Visual sets sorted successfuly.','envision'),
				'key' 	=> 'update'
			); break;
		case 9017:
			$out = array(
				'title' => __('Error','envision'),
				'msg' 	=> __('Could not be found any .skin file in the zip file','envision'),
				'key' 	=> 'error'
			); break;
		case 9018:
			$out = array(
				'title' => __('Error','envision'),
				'msg' 	=> __(SKINS_DIR_PATH.' folder cannot opened to scan a visual settings file','envision'),
				'key' 	=> 'error'
			); break;
		case 9019:
			$out = array(
				'title' => __('Error','envision'),
				'msg' 	=> __('Fatal Error: Php ZipArchive extension is not found. You can not import a zip file','envision'),
				'key' 	=> 'error'
			); break;
		case 9020:
			$out = array(
				'title' => __('Error','envision'),
				'msg' 	=> sprintf(__('The import was cancelled. <strong>%s</strong> folder is not writable','envision'), SKINS_DIR_PATH),
				'key' 	=> 'error'
			); break;

		/**
		 *	Other Messages
		 */
		case 8001:
			$out = array(
				'msg' 	=> __('Blog Page Created And Defined Successfully','envision'),
				'key' 	=> 'add'
			); break;
		case 8002:
			$out = array(
				'msg' 	=> __('Portfolio Page Created And Defined Successfully','envision'),
				'key' 	=> 'add'
			); break;
		case 8003:
			$out = array(
				'msg' 	=> __('Homepage Created successfuly','envision'),
				'key' 	=> 'add'
			); break;
		case 8004:
			$out = array(
				'msg' 	=> __('Slider Samples Created successfuly','envision'),
				'key' 	=> 'add'
			); break;

		/**
		 *	Font Messages
		 */
		case 8010:
			$out = array(
				'msg' 	=> __('Fonts Updated','envision'),
				'key' 	=> 'update'
			); break;
		case 8011:
			$out = array(
				'msg' 	=> __('Font Settings Saved','envision'),
				'key' 	=> 'update'
			); break;
		case 8012:
			$out = array(
				'msg' 	=> __('Web Fonts Saved','envision'),
				'key' 	=> 'update'
			); break;
		case 8013:
			$out = array(
				'msg' 	=> __('Custom Service Fonts Saved','envision'),
				'key' 	=> 'update'
			); break;

		/**
		 *	Composer Messages
		 */
		case 3101:
			$out = array(
				'title' => __('Saved','envision'),
				'msg' 	=> __('Composer template saved successfuly.','envision'),
				'key' 	=> 'update'
			); break;
		case 3102:
			$out = array(
				'title' => __('Hoops!','envision'),
				'msg' 	=> __('Post ID not found','envision'),
				'key' 	=> 'cancel'
			); break;
		case 3103:
			$out = array(
				'title' => __('Hoops!','envision'),
				'msg' 	=> __('Please insert a name for composer template','envision'),
				'key' 	=> 'cancel'
			); break;
		case 3104:
			$out = array(
				'title' => __('Hoops!','envision'),
				'msg' 	=> __('Please add some composer element to save it','envision'),
				'key' 	=> 'cancel'
			); break;
		case 3105:
			$out = array(
				'title' => __('Error','envision'),
				'msg' 	=> __('The template data cannot found.','envision'),
				'key' 	=> 'cancel'
			); break;
		case 3106:
			$out = array(
				'title' => __('Template Deleted','envision'),
				'msg'	=> __('The template deleted successfuly.','envision'),
				'key' 	=> 'cancel'
			); break;
		case 3107:
			$out = array(
				'msg' 	=> __('Export Data Generated','envision'),
				'key' 	=> 'add'
			); break;
		case 3108:
			$out = array(
				'title' => __('Error','envision'),
				'msg' 	=> __('Please select a composer widget to export.','envision'),
				'key' 	=> 'cancel'
			); break;
		case 3109:
			$out = array(
				'msg' 	=> __('The data imported successfuly.','envision'),
				'key' 	=> 'add'
			); break;
		case 3110:
			$out = array(
				'msg' 	=> __('Imported data type doesn\'t compatible with this theme.','envision'),
				'key' 	=> 'cancel'
			); break;
		case 3111:
			$out = array(
				'msg' 	=> __('Any content cannot imported with the data that imported.','envision'),
				'key' 	=> 'cancel'
			); break;

		/**
		 *	System Messages
		 */
		case 9000:
			$out = array(
				'msg' 	=> __('All Theme Settings Restored','envision'),
				'key' 	=> 'cancel'
			); break;
		case 9001:
			$out = array(
				'msg' 	=> __('All Cache Files Removed','envision'),
				'key' 	=> 'ok'
			); break;
		case 9002:
			$out = array(
				'msg' 	=> __('Option File Uploaded & Changes Saved','envision'),
				'key' 	=> 'add'
			); break;
		case 9003:
			$out = array(
				'msg' 	=> __('Please Upload A File','envision'),
				'key' 	=> 'cancel'
			); break;
		case 9004:
			$out = array(
				'msg' 	=> __('The uploaded file not compatible with the theme!','envision'),
				'key' 	=> 'cancel'
			); break;
		case 9005:
			$out = array(
				'msg' 	=> __('There was an error uploading the file, please try again!','envision'),
				'key' 	=> 'cancel'
			); break;
		case 9006:
			$out = array(
				'msg' 	=> __('Type of the uploaded file not compatible with the theme','envision'),
				'key' 	=> 'cancel'
			); break;
		case 9007:
			$out = array(
				'msg' 	=> __('File size too large','envision'),
				'key' 	=> 'cancel'
			); break;
		case 9008:
			$out = array(
				'msg' 	=> __('Could not save uploaded file. The upload was cancelled, or server error encountered','envision'),
				'key' 	=> 'cancel'
			); break;
		case 9009:
			$out = array(
				'msg' 	=> __('The upload was cancelled because of upload directory isn\'t writable','envision'),
				'key' 	=> 'cancel'
			); break;

		case 9012:
			$out = array(
				'msg' 	=> __('Icon Set Imported','envision'),
				'key' 	=> 'add'
			); break;
		case 9013:
			$out = array(
				'msg' 	=> __('The action has been canceled. Please select some skin to backup','envision'),
				'key' 	=> 'cancel'
			); break;
		case 9014:
			$out = array(
				'msg' 	=> __('Error: The Zip File Cannot Opened','envision'),
				'key' 	=> 'cancel'
			); break;
		case 9015:
			$out = array(
				'msg' 	=> __('Please Upload A Zip File','envision'),
				'key' 	=> 'cancel'
			); break;

		case 9021:
			$out = array(
				'msg' 	=> __('The type of uploaded file is not valid','envision'),
				'key' 	=> 'error'
			); break;
		case 9022:
			$out = array(
				'msg' 	=> __('The action cannot complated.','envision'),
				'key' 	=> 'error'
			); break;

	}

	return apply_filters('cloudfw_admin_messages', $out, $message_id);
}