<?php

/**
 *  Adds comments and related post after the portfolio post contents.
 *
 *  @since 1.0
 */
add_filter( 'the_content', 'cloudfw_add_contents_after_pages', 11 );
function cloudfw_add_contents_after_pages( $content ) {
	if ( ! is_singular('page') ) {
	    return $content;

    }

    ob_start();
    echo "
        <div class='clearfix'></div>
    ";
    echo wp_link_pages(array(
        'before'           => '<p>' . __('Pages:', 'envision'),
        'after'            => '</p>',
        'link_before'      => '',
        'link_after'       => '',
        'next_or_number'   => 'number',
        'nextpagelink'     => cloudfw_translate( 'next_page' ),
        'previouspagelink' => cloudfw_translate( 'previous_page' ),
        'pagelink'         => '%',
        'echo'             => 0
    ));

    $content .= ob_get_contents();
    ob_end_clean();

    if ( ! cloudfw_check_onoff('global', 'disable_page_comments', false) && ! post_password_required() ) {
        if ( ( comments_open() || get_comments_number() ) && cloudfw('get_meta', 'comments_enable') != 'hide' ) {
            ob_start();
            echo "
                <div class='clearfix'></div>
            ";
            comments_template( '', true );
            $content .= ob_get_contents();
            ob_end_clean();
        }
    }


	return $content;
}