<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

//$custom_sidebar = cloudfw_check_default(cloudfw( 'get_sidebar_id' ), 0);
$sidebar_position = cloudfw( 'get', 'sidebar-position' );
$custom_sidebar = cloudfw( 'get_sidebar_id' );
$hide_sidebar_on_phones = cloudfw_check_onoff( 'global', 'hide_sidebar_on_phones' );
$hide_sidebar_on_tablets = cloudfw_check_onoff( 'global', 'hide_sidebar_on_tablets' );
$class = '';

if ( $hide_sidebar_on_phones ) {
	$class .= ' hidden-phone';
}

if ( $hide_sidebar_on_tablets ) {
	$class .= ' hidden-tablet';
}

if ( is_active_sidebar( $custom_sidebar ) || cloudfw_custom_sidebar_exists( $custom_sidebar ) ):

?>

	<aside id="primary-sidebars" class="sidebar-area widget-area<?php echo esc_attr($class); ?> custom-widget-<?php echo esc_attr($custom_sidebar);?>">
			<?php dynamic_sidebar( $custom_sidebar ); ?>
	<div id="sidebar-shadow"><div id="sidebar-shadow-top"></div><div id="sidebar-shadow-bottom"></div></div>
	</aside><!-- #custom(<?php echo esc_attr($custom_sidebar);?>) .widget-area -->


<?php else:
	if (is_search()) {$get_sidebar = 'searchpage-widget-area';}
	elseif (is_category()) {$get_sidebar = 'archive-widget-area';}
	elseif (is_archive()) {$get_sidebar = 'archive-widget-area';}
	elseif (is_page()) {$get_sidebar = 'default-widget-area';}
	else {$get_sidebar = 'blog-widget-area';}

?>

	<aside id="primary-sidebars" class="sidebar-area widget-area primary-sidebars <?php echo esc_attr($class); ?>">
	<?php if ( ! dynamic_sidebar( $get_sidebar ) ) : ?>
			<?php cloudfw( 'default_sidebar', $get_sidebar );?>
    <?php endif;?>
	<div id="sidebar-shadow"><div id="sidebar-shadow-top"></div><div id="sidebar-shadow-bottom"></div></div>
	</aside>

<?php endif;