<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( $related_products ) :

	global $woocommerce_loop;

	$columns = cloudfw_get_option( 'woocommerce', 'related_column' );
	if ( empty($columns) ) {
		$columns = 3;
	}

	$woocommerce_loop['columns'] = $columns;
	$woocommerce_loop['image_ratio'] = cloudfw_get_option( 'woocommerce', 'related_media_ratio' );
	$woocommerce_loop['shadow'] = cloudfw_get_option( 'woocommerce', 'related_shadow' );
	$woocommerce_loop['effect'] = cloudfw_get_option( 'woocommerce', 'related_effect' );
	$woocommerce_loop['show_hover'] = cloudfw_check_onoff( 'woocommerce', 'related_hover' );
	$woocommerce_loop['hover_effect'] = cloudfw_get_option( 'woocommerce', 'related_hover_effect' );

	global $woocommerce_loop_layout;
		   $woocommerce_loop_layout = cloudfw_get_option('woocommerce', 'related_layout');

?>

	<?php echo do_shortcode(cloudfw_transfer_shortcode_attributes( 'title', array( 'element' => 'h3' ), '<strong>' . __('Related products','envision') . '</strong>' )); ?>

	<section class="related products ui--pass">

		<?php woocommerce_product_loop_start(); ?>

			<?php foreach ( $related_products as $related_product ) : ?>

				<?php
				 	$post_object = get_post( $related_product->get_id() );

					setup_postdata( $GLOBALS['post'] =& $post_object );

					wc_get_template_part( 'content', 'product' ); ?>

			<?php endforeach; ?>

		<?php woocommerce_product_loop_end(); ?>

	</section>
<?php endif;

wp_reset_postdata();
