<?php

return array(
	
		array(
			'type'      => 'module',
			'title'     => __('Visibility','envision-core'),
			'data'      => array(

				## Element
				array(
					'type'      =>  'select',
					'id'        =>  'the_device',
					'value'     =>  $that->get_value('the_device'),
					'source'    =>  array(
						'type'      =>  'function',
						'function'  =>  'cloudfw_admin_get_visibility_options'
					),
					'width'     =>  250,
				), // #### element: 0

			)

		),


		array(
			'type'      =>  'module',
			'title'     =>  __('Columns','envision-core'),
			'data'      =>  array(
				array(
					'type'      =>  'slider',
					'id'        =>  $that->get_field_name('gallery_columns'),
					'value'     =>  $that->get_value('gallery_columns', '3'),
					'min'       =>  1,
					'max'       =>  12,
					'step'      =>  1,
					'width'     =>  '250',
					'unit'      =>  __('column(s)','envision-core'),
				)
			),
		),

		array(
			'type'      =>  'module',
			'title'     =>  __('Crop Images','envision-core'),
			'data'      =>  array(
				array(
					'type'      =>  'onoff',
					'id'        =>  $that->get_field_name('gallery_crop'),
					'value'     =>  $that->get_value('gallery_crop'),
				)
			),
		),

		array(
			'type'      =>  'module',
			'title'     =>  array(__('Custom Thumbnail Width','envision-core'), __('Custom Thumbnail Height','envision-core')),
			'layout'    =>  'split',
			'data'      =>  array(
	
				## Element
				array(
					'type'      =>  'text',
					'id'        =>  $that->get_field_name('gallery_width'),
					'value'     =>  $that->get_value('gallery_width'),
					'width'     =>  70,
				),
	
				## Element
				array(
					'type'      =>  'text',
					'id'        =>  $that->get_field_name('gallery_height'),
					'value'     =>  $that->get_value('gallery_height'),
					'width'     =>  70,
				),

			)

		),

		array(
			'type'      =>  'module',
			'title'     =>  __('Carousel Gallery?','envision-core'),
			'data'      =>  array(
				array(
					'type'      =>  'onoff',
					'id'        =>  $that->get_field_name('gallery_carousel'),
					'value'     =>  $that->get_value('gallery_carousel', 'FALSE'),
				)
			),
		),

		array(
			'type'      =>  'module',
			'title'     =>  __('Carousel Auto-rotate?','envision-core'),
			'data'      =>  array(
				array(
					'type'      =>  'onoff',
					'id'        =>  $that->get_field_name('gallery_carousel_autorotate'),
					'value'     =>  $that->get_value('gallery_carousel_autorotate', 'FALSE'),
				)
			),
		),

		array(
			'type'		=> 'module',
			'title'		=> __('Carousel Transition Effect','envision-core'),
			'data'		=> array(

				## Element
				array(
					'type'		=>	'select',
					'ui'		=>	true,
					'id'        =>  $that->get_field_name('gallery_carousel_effect'),
					'value'		=>	$that->get_value('gallery_carousel_effect'),
					'source'	=>	array(
						'NULL'		=>	__('Default','envision-core'),
						'slide'		=>	__('Slide Effect','envision-core'),
						'fade'		=>	__('Fade Effect','envision-core'),
					),
					'width'		=> 250,
				), // #### element: 0

			)

		),

		array(
			'type'      =>  'module',
			'title'     =>  __('Disable Links?','envision-core'),
			'data'      =>  array(
				array(
					'type'      =>  'onoff',
					'id'        =>  $that->get_field_name('disable_links'),
					'value'     =>  $that->get_value('disable_links', 'FALSE'),
				)
			),
		),

		array(
			'type'      =>  'module',
			'title'     =>  __('Enable Lightbox Links?','envision-core'),
			'data'      =>  array(
				array(
					'type'      =>  'onoff',
					'id'        =>  $that->get_field_name('gallery_lightbox'),
					'value'     =>  $that->get_value('gallery_lightbox', true),
				)
			),
		),

		array(
			'type'		=> 'module',
			'title'		=> __('Hover Button Color','envision-core'),
			'data'		=> array(

				## Element
				array(
					'type'		=>	'select',
					'ui'		=>	true,
					'id'        =>  $that->get_field_name('button_color'),
					'value'		=>	$that->get_value('button_color', 'btn-grey'),
					'source'	=>	array(
						'type'		=>	'function',
						'function'	=>	'cloudfw_admin_loop_button_colors'
					),
					'width'		=> 250,
				), // #### element: 0

			)

		),

		array(
			'type'		=> 'module',
			'title'		=> __('Hover Button Icon','envision-core'),
			'data'		=> array(

				## Element
				array(
					'type'		=>	'icon-selector',
					'id'        =>  $that->get_field_name('button_icon'),
					'value'		=>	$that->get_value('button_icon'),
				), // #### element: 0

			)

		),

		array(
			'type'      =>  'module',
			'title'     =>  __('Random Sorting','envision-core'),
			'data'      =>  array(
				array(
					'type'      =>  'onoff',
					'id'        =>  $that->get_field_name('gallery_random'),
					'value'     =>  $that->get_value('gallery_random', 'FALSE'),
				)
			),
		),

		array(
			'type'      =>  'module',
			'layout'    =>  'raw',
			'data'      =>  array(


				array(
					'type'      =>  'sorting',
					'id'        =>  'gallery',
					'item:id'   =>  'gallery_clone',
					'axis'      =>  'both',
					'data'      => 

						cloudfw_core_loop_multi_option( 
							
							array(
								'start'     => 5,
								'indicator' => $that->get_value('indicator'),
								'dummy'     => true,
								'data'      => 


									array(
										'type'      =>  'gallery',
										'class'     =>  'gallery_clone_class',
										'sync'      =>  $that->get_field_name('gallery_image'),
										'data'      =>  array(
						
											## Module Item
											array(
												'type'      =>  'remove',
											),

											## Module Item
											array(
												'type'      =>  'indicator',
												'id'        =>  $that->get_field_name('indicator'),
											),

											## Module Item
											array(
												'type'      =>  'module',
												'title'     =>  __('Image','envision-core'),
												'data'      =>  array(

													## Element
													array(
														'type'      =>  'upload',
														'id'        =>  $that->get_field_name('gallery_image'),
														'value'     =>  $that->get_value('gallery_image'),
														'reset'     =>  '',
														'brackets'  =>  true,
														'store'     =>  true,
														'removable' =>  true,
														'library'   =>  true,

													),
												)

											),

											## Module Item
											array(
												'type'      =>  'module',
												'title'     =>  __('Custom Link','envision-core'),
												'data'      =>  array(

													## Element
													array(
														'type'      =>  'page-selector',
														'id'        =>  $that->get_field_name('gallery_link'),
														'value'     =>  $that->get_value('gallery_link'),
														'reset'     =>  '',
														'_class'    =>  'input_150',
														'brackets'  =>  true,

													),

												)

											),

											array(
												'type'      =>  'module',
												'title'     =>  __('Title for Lightbox','envision-core'),
												'data'      =>  array(

													## Element
													array(
														'type'      =>  'text',
														'id'        =>  $that->get_field_name('gallery_title'),
														'value'     =>  $that->get_value('gallery_title'),
														'width'     =>  400,
														'reset'     =>  '',
														'brackets'  =>  true,


													),

												)

											),

											array(
												'type'      =>  'module',
												'title'     =>  __('Description for Lightbox','envision-core'),
												'data'      =>  array(

													## Element
													array(
														'type'      =>  'textarea',
														'id'        =>  $that->get_field_name('gallery_desc'),
														'value'     =>  $that->get_value('gallery_desc'),
														'width'     =>  400,
														'line'      =>  2,
														'reset'     =>  '',
														'brackets'  =>  true,


													),

												)

											),

										)

									),

							)

						)

				),

				## Element
				array(
					'type'      =>  'html',
					'data'      =>  '
						<a data-target="" class="cloudfw-action-duplicate cloudfw-ui-button cloudfw-ui-button-metro cloudfw-ui-button-metro-green" href="javascript:;" style="margin-bottom: 5px;"><span>'.__('+ Add New Gallery Item','envision-core').'</span></a>
						<a data-target="" class="cloudfw-action-gallery-from-library cloudfw-ui-button cloudfw-ui-button-metro cloudfw-ui-button-metro-grey" href="javascript:;"><span>'.__('Insert from Media Library','envision-core').'</span></a>
					',
				), // #### element: 0

			)
		
		),

);