<?php

/** Class */
class CloudFw_Widget_Blog_List extends CloudFw_Widgets {
	/** Variables */
	private $class;

	/** Init */
	function __construct() {
		parent::__construct(
			/** Base ID */
			'widget_cloudfw_blog_list',
			/** Title */
			__('Theme - Blog Posts','envision-core'),
			/** Other Options */
			array(
				'classname'   => 'widget_cloudfw_blog_list',
				'description' => '',
			),
			/** Size */
			array( 'width'  => 300 )
		);


	}

	/** Render */
	function widget($args, $instance) {
		extract($args, EXTR_SKIP);
		$title = isset($instance['title']) ? $instance['title'] : NULL;

		echo cloudfw_escape( $before_widget);
		$title = empty($title) ? '' : apply_filters('widget_title', $title);

		if ( !empty( $title ) ) {
			echo cloudfw_escape( $before_title . $title . $after_title );
		}

		$instance['columns'] = 1;

		if ( empty($instance['layout']) ) {
			$instance['layout'] = 'mini-carousel';
		}

		if ( empty($instance['limit']) || !is_numeric($instance['limit']) ) {
			$instance['limit'] = 2;
		}

		if ( empty($instance['excerpt_length']) || !is_numeric($instance['excerpt_length']) ) {
			$instance['excerpt_length'] = 10;
		}

		if ( !empty( $instance['category'] ) ) {
			$instance['from'] = 'a category';
		}

		if ( class_exists( "CloudFw_Shortcode_Blog" ) ) {
			$this->class = new CloudFw_Shortcode_Blog();
			$this->class->is_widget = true;
			$this->class->widget = $this;
			echo cloudfw_escape( $this->class->shortcode( $instance ) );
		}

		echo cloudfw_escape( $after_widget);
	}

	/** Scheme */
	function scheme( $data = array() ) {

		/** Defaults */
		$data = wp_parse_args( $data, array( 'layout' => 'mini', 'limit' => 2, 'excerpt_length' => 10, 'image_ratio' => '1:1'  ) );

		$scheme = array();
		$scheme['data'] = array(
			array(
				'type'		=>	'json',
				'variable'	=>	'widget_options',
				'data'		=>	array(
					'not_in'		=>	array( 'header-widget-area' )
				)

			),

			## Module Item
			array(
				'type'		=>	'module',
				'title'		=>	__('Title','envision-core'),
				'data'		=>	array(
					array(
						'type'		=>	'text',
						'id'		=>	$this->get_field_name('title'),
						'value'		=>	isset($data['title']) ? $data['title'] : NULL,
						'_class'	=>	'input_200'
					)
				)
			),

			array(
				'type'		=> 'module',
				'title'		=> __('Title Size','envision-core'),
				'data'		=> array(

					## Element
					array(
						'type'		=>	'select',
						'id'		=>	$this->get_field_name('title_element'),
						'value'		=>	isset($data['title_element']) ? $data['title_element'] : NULL,
						'ui'		=>	true,
						'main_class'=>  'input input_250',
						'source'	=>	array(
							'NULL'		=> __('Default','envision-core'),
							'h1'		=> 'H1',
							'h2'			=> 'H2',
							'h3'		=> 'H3',
							'h4'		=> 'H4',
							'h5'		=> 'H5',
							'h6'		=> 'H6',
							'strong'	=> __('Strong','envision-core'),
						)

					), // #### element: 0

				)

			),

			array(
				'type'		=> 'module',
				'title'		=> __('Layout','envision-core'),
				'data'		=> array(

					## Element
					array(
						'type'		=>	'select',
						'id'		=>	$this->get_field_name('layout'),
						'value'		=>	isset($data['layout']) ? $data['layout'] : NULL,
						'source'	=>	array(
							'mini' 				=> __('Mini Layout','envision-core'),
							'mini-carousel'		=> __('Mini Carousel Layout','envision-core'),
						),
						'width'		=> 200,
					), // #### element: 0

				)

			),

			array(
				'type'		=> 'module',
				'title'		=> __('List Style','envision-core'),
				'data'		=> array(

					## Element
					array(
						'type'		=>	'select',
						'id'		=>	$this->get_field_name('list_style'),
						'value'		=>	isset($data['list_style']) ? $data['list_style'] : NULL,
						'source'	=>	array(
							'type' 			=> 'function',
							'function'		=> 'cloudfw_admin_loop_blog_list_styles',
						),
						'width'		=> 200,
					), // #### element: 0

				)

			),

			array(
				'type'		=> 'module',
				'title'		=> __('Image Aspect Ratio','envision-core'),
				'data'		=> array(

					## Element
					array(
						'type'		=>	'select',
						'id'		=>	$this->get_field_name('image_ratio'),
						'value'		=>	isset($data['image_ratio']) ? $data['image_ratio'] : '1:1',
						'ui'		=>	true,
						'main_class'=>  'input input_250',
						'source'	=>	array(
							'type' 		=> 'function',
							'function'	=> 'cloudfw_admin_loop_aspect_ratio',
						),

					), // #### element: 0

				)

			),

			## Module Item
			array(
				'type'		=>	'module',
				'title'		=>	__('Show Excerpt','envision-core'),
				'data'		=>	array(
					array(
						'type'		=>	'onoff',
						'id'		=>	$this->get_field_name('show_excerpt'),
						'value'		=>	isset($data['show_excerpt']) ? $data['show_excerpt'] : NULL,
					)
				)
			),

			## Module Item
			array(
				'type'		=>	'module',
				'title'		=>	__('Excerpt Length','envision-core'),
				'data'		=>	array(
					array(
						'type'		=>	'text',
						'id'		=>	$this->get_field_name('excerpt_length'),
						'value'		=>	isset($data['excerpt_length']) ? $data['excerpt_length'] : NULL,
						'width'		=>	50,
					)
				)
			),

			## Module Item
			array(
				'type'		=>	'module',
				'title'		=>	__('Show Read More Button','envision-core'),
				'data'		=>	array(
					array(
						'type'		=>	'onoff',
						'id'		=>	$this->get_field_name('show_readmore'),
						'value'		=>	isset($data['show_readmore']) ? $data['show_readmore'] : NULL,
					)
				)
			),

			array(
				'type'		=>	'module',
				'title'		=>	__('Category Filter','envision-core'),
				'data'		=>	array(

					## Element
					array(
						'type'		=>	'select',
						'id'		=>	$this->get_field_name('category'),
						'value'		=>	isset($data['category']) ? $data['category'] : NULL,
						'main_class'=>  'input input_250',
						'ui'		=>	true,
						'source'	=>	array(
							'type'		=>	'function',
							'function'	=>	'cloudfw_admin_loop_terms',
							'vars'		=>	array('category', __('All Categories','envision-core'))
						)
					), // #### element: 0

				)

			),


			## Module Item
			array(
				'type'		=>	'module',
				'title'		=>	__('Post Limit','envision-core'),
				'data'		=>	array(
					array(
						'type'		=>	'text',
						'id'		=>	$this->get_field_name('limit'),
						'value'		=>	isset($data['limit']) ? $data['limit'] : NULL,
						'width'		=>	70
					)
				)
			),


		);

		return $scheme;

	}

}

/**
 *	Register Widget
 */
register_widget('CloudFw_Widget_Blog_List');