<?php

/* GENERADOR DE COTIZACION ONLINE */
/* Se usará constantes y variables, de origen de Base de Datos para armar el documento */

//Variables y Constantes
$nombrePDF = 'Cotizacion.pdf';
$C_primeraLinea = 'Espectacular  hotel  se  encuentra  ubicado  en  la  península,  en  medio  de  atractivos naturales  y fascinante entorno de la isla del amor, estuario y amplias playas cristalinas que nos adentran a un mundo natural mágico y desconocido.'; //Primera Línea de Cabecera
$C_segundaLinea = 'Nota: Consulte nuestros precios para obtener descuentos especiales'; //Segunda Línea de Cabecera
$C_terceraLinea = 'Todas nuestras habitaciones tienen los siguientes servicios:'; //Tercera Línea (Texto Intermedio)
$T1_primero = 'TIPO DE HABITACIÓN';
$T1_segundo = 'TARIFA DE ALOJAMIENTO';
$T2_primero = 'SERVICIOS DE ALOJAMIENTO';
$T2_segundo = 'ACTIVIDADES TURÍSTICAS';
//$F_ciudad = 'Santo Domingo de los Tsáchilas, Ecuador';
//$F_sitioWeb = 'http://www.iquiss.com.ec';
//$vendedor = 'Isaías Quezada V.';
//$cargo = 'AGENTE DE VENTAS';

//Librerías
//require('fpdf.php');
require('code128.php');

//Inicialización del documento
$pdf=new PDF_Code128();
//$pdf = new FPDF();


//Definición de Fuentes a Usar
$pdf->AddFont('helvetica','R','helvetica.php');
$pdf->AddFont('helvetica','B','helveticab.php');
//$pdf->AddFont('Segoe UI','','segoeui.php');
//$pdf->AddFont('Segoe UI','B','seguisb_0.php');
//$pdf->AddFont('Segoe UI','I','segoeuii.php');

//Añadir página al documento
$pdf->AddPage();


// Títulos Cabecera
//Logo
$pdf->Image('logo_bocana.jpg',80,20);

//Fondo_Logo
$pdf->Image('fondo_bocana.png',45,130);

// Primera Línea
$pdf->SetFont('helvetica','R',12);
$pdf->SetTextColor(0,0,0); //negro
$pdf->SetXY(20, 60);
$pdf->MultiCell(170, 5, utf8_decode($C_primeraLinea),0);

// Segunda Línea
$pdf->SetFillColor(252,215,178);
$pdf->Rect(20, 84, 169.5, 6, 'F');
$pdf->SetFont('helvetica','B',12);
$pdf->SetTextColor(0,0,0); //negro
$pdf->SetXY(20, 85);
$pdf->MultiCell(170, 5, utf8_decode($C_segundaLinea),0);
//$pdf->Cell(202,28,utf8_decode($C_primeraLinea),1,1,'J');  //Primera Línea
//helveticab

//Línea azul (habitaciones)
$pdf->Image('linea_azul.png',20,95,-97);
$pdf->Image('linea_azul.png',20,98.3,-97);
$pdf->Image('linea_azul.png',20,101.7,-97);
//Títulos
$pdf->SetFont('helvetica','B',11);
$pdf->SetTextColor(255,255,255); //blanco
$pdf->SetXY(25, 98);
$pdf->MultiCell(45, 5, utf8_decode($T1_primero),0);
$pdf->SetXY(130, 98);
$pdf->MultiCell(55, 5, utf8_decode($T1_segundo),0);

//Linea gris dependiente del contenido
$pdf->Image('linea_gris.png',20,106.3,169.3,45);

//Texto intermedio
$pdf->SetFont('helvetica','R',12);
$pdf->SetTextColor(0,0,0); //negro
$pdf->SetXY(20, 155);
$pdf->MultiCell(170, 5, utf8_decode($C_terceraLinea),0);

//Linea azul (servicios)
$pdf->Image('linea_azul.png',20,164,-97);
$pdf->Image('linea_azul.png',20,167.3,-97);
//Títulos
$pdf->SetFont('helvetica','B',11);
$pdf->SetTextColor(255,255,255); //blanco
$pdf->SetXY(25, 165);
$pdf->MultiCell(65, 5, utf8_decode($T2_primero),0);
$pdf->SetXY(130, 165);
$pdf->MultiCell(55, 5, utf8_decode($T2_segundo),0);

//Linea gris dependiente del contenido
$pdf->Image('linea_gris.png',20,171.8,169.3,45);

// BASE DE DOCUMENTO //
// Logo
/*
$pdf->Image('fondo_generico.png',0,0,210);
//Definición Global de Fuente sólo para Base de Documento
$pdf->SetFont('ZagRegular','',20);

// Segunda y Tercera Línea
$pdf->SetTextColor(209,210,211); //gris
$pdf->SetXY(5, 10);
$pdf->Cell(202,8,utf8_decode($C_segundaLinea),0,1,'R');
$pdf->SetXY(5, 17);
$pdf->Cell(202,8,utf8_decode($C_terceraLinea),0,1,'R');
// Títulos Pie de Página
// Dirección
$pdf->SetTextColor(255,255,255); //blanco
$pdf->Text(10,283,utf8_decode($F_direccion));
// Teléfono
$pdf->Text(200 - (strlen($F_telefono)*2.5),283,utf8_decode($F_telefono));
// Ciudad
$pdf->Text(10,290,utf8_decode($F_ciudad));
// Sitio Web
$pdf->Text(200 - ((strlen($F_sitioWeb) - 1)*2.5),290,utf8_decode($F_sitioWeb));

//SECCION 1. Datos de Cliente/Cotizacion
$pdf->SetTextColor(0,0,0); //negro
$pdf->SetFont('ZagRegular','B',20);
$pdf->Text(134,50,utf8_decode('Cotización #'));
$pdf->SetFont('Segoe UI','B',18);
$pdf->Text(167,50,utf8_decode('01D2-16-001'));
// Codigo de Barras
$code='C-01D216001';
//Code128($x, $y, $code, $w, $h)
$pdf->Code128(134,51,$code,68,6);
// Datos de Cliente
$pdf->SetFont('ZagRegular','B',13);
$pdf->Text(10,74,utf8_decode('Cliente:'));
$pdf->Text(142,74,utf8_decode('C.I. o R.U.C.:'));
$pdf->Text(10,80,utf8_decode('Atención:'));
$pdf->Text(142,80,utf8_decode('Ciudad:'));
$pdf->Text(10,86,utf8_decode('Dirección:'));
$pdf->Text(142,86,utf8_decode('Teléfono:'));
$pdf->Text(10,92,utf8_decode('Email:'));
$pdf->Text(142,92,utf8_decode('Fecha:'));
$pdf->SetFont('Segoe UI','',11);
$pdf->Text(27,74,utf8_decode('XXX999 - SCANNEREXPRESS SEGURIDAD INTEGRADA CIA LTDA')); // Cliente
$pdf->Text(164,74,utf8_decode('1718767948001')); // CI o RUC
$pdf->Text(27,80,utf8_decode('SEGUNDO ISAIAS QUEZADA VALENCIA')); // Atencion
$pdf->Text(164,80,utf8_decode('SANTO DOMINGO')); // Ciudad
$pdf->Text(27,86,utf8_decode('LUIS CORDERO Y ANTONIO ANTE, COOP 2 PINOS')); // Direccion
$pdf->Text(164,86,utf8_decode('0997141334')); // Telefono
$pdf->Text(27,92,utf8_decode('iquiss@gmail.com')); // EMAIL
$pdf->Text(164,92,utf8_decode('05/SEPTIEMBRE/2016')); // Fecha

//SECCION 1. Tabla de Detalle de Productos/Servicios
// Armando cuadros
$pdf->SetLineWidth(0.5);
$pdf->Rect(10, 95, 190, 95);
$pdf->Line(31, 95, 31, 190); //Código
$pdf->Line(130, 95, 130, 190); //Descripción
$pdf->Line(149, 95, 149, 190); //Cantidad
$pdf->Line(174, 95, 174, 190); //Valor Unitario
$pdf->Line(10, 102, 200, 102); //FIN TITULO TABLA
// Textos
$pdf->SetFont('ZagRegular','B',12);
$pdf->SetTextColor(0,0,0); //negro
$pdf->Text(15,100,utf8_decode('CODIGO'));
$pdf->Text(72,100,utf8_decode('DESCRIPCION'));
$pdf->Text(132,100,utf8_decode('CANTIDAD'));
$pdf->Text(152,100,utf8_decode('VALOR UNIT.'));
$pdf->Text(176,100,utf8_decode('VALOR TOTAL'));

/* DETALLE DE COTIZACION
$saltoLinea = 4;
$lineaInicial = 107;

/* Codigo Repetitivo
$pdf->SetFont('Segoe UI','',9);
$pdf->Text(11,$lineaInicial,utf8_decode('MB987GBT09')); //Código Producto
$pdf->SetFont('Segoe UI','',10);
$pdf->Text(33,$lineaInicial,utf8_decode('Gigabyte GA-H81M-DS2 - 1.0 - placa base')); //Título Producto
$cantidad = '123456';
$valorUnitario = '99999.99';
$pdf->SetXY(133,$lineaInicial-3);
$pdf->Cell(13, 3, utf8_decode($cantidad),0,0,'R',0,0);
$pdf->SetXY(153,$lineaInicial-3);
$pdf->Cell(18, 3, utf8_decode($valorUnitario),0,0,'R',0,0);
$pdf->SetXY(179,$lineaInicial-3);
$pdf->Cell(18, 3, utf8_decode($valorUnitario),0,0,'R',0,0);
$pdf->SetFont('Segoe UI','',8);
$lineaInicial = $lineaInicial + $saltoLinea;
$pdf->Text(34,$lineaInicial,utf8_decode('* micro ATX')); //Características Producto
$lineaInicial = $lineaInicial + $saltoLinea;
$pdf->Text(34,$lineaInicial,utf8_decode('* LGA1150 Socket')); //Características Producto
//nueva linea
$lineaInicial = $lineaInicial + $saltoLinea + $saltoLinea;
$pdf->SetFont('Segoe UI','',9);
$pdf->Text(11,$lineaInicial,utf8_decode('MB987GBT09')); //Código Producto
$pdf->SetFont('Segoe UI','',10);
$pdf->Text(33,$lineaInicial,utf8_decode('Gigabyte GA-H81M-DS2 - 1.0 - placa base')); //Título Producto
$cantidad = '123456';
$valorUnitario = '99999.99';
$pdf->SetXY(133,$lineaInicial-3);
$pdf->Cell(13, 3, utf8_decode($cantidad),0,0,'R',0,0);
$pdf->SetXY(153,$lineaInicial-3);
$pdf->Cell(18, 3, utf8_decode($valorUnitario),0,0,'R',0,0);
$pdf->SetXY(179,$lineaInicial-3);
$pdf->Cell(18, 3, utf8_decode($valorUnitario),0,0,'R',0,0);
$pdf->SetFont('Segoe UI','',8);
$lineaInicial = $lineaInicial + $saltoLinea;
$pdf->Text(34,$lineaInicial,utf8_decode('* micro ATX')); //Características Producto
$lineaInicial = $lineaInicial + $saltoLinea;
$pdf->Text(34,$lineaInicial,utf8_decode('* LGA1150 Socket')); //Características Producto
//nueva linea
$lineaInicial = $lineaInicial + $saltoLinea + $saltoLinea;
$pdf->SetFont('Segoe UI','',9);
$pdf->Text(11,$lineaInicial,utf8_decode('MB987GBT09')); //Código Producto
$pdf->SetFont('Segoe UI','',10);
$pdf->Text(33,$lineaInicial,utf8_decode('Gigabyte GA-H81M-DS2 - 1.0 - placa base')); //Título Producto
$cantidad = '123456';
$valorUnitario = '99999.99';
$pdf->SetXY(133,$lineaInicial-3);
$pdf->Cell(13, 3, utf8_decode($cantidad),0,0,'R',0,0);
$pdf->SetXY(153,$lineaInicial-3);
$pdf->Cell(18, 3, utf8_decode($valorUnitario),0,0,'R',0,0);
$pdf->SetXY(179,$lineaInicial-3);
$pdf->Cell(18, 3, utf8_decode($valorUnitario),0,0,'R',0,0);
$pdf->SetFont('Segoe UI','',8);
$lineaInicial = $lineaInicial + $saltoLinea;
$pdf->Text(34,$lineaInicial,utf8_decode('* micro ATX')); //Características Producto
$lineaInicial = $lineaInicial + $saltoLinea;
$pdf->Text(34,$lineaInicial,utf8_decode('* LGA1150 Socket')); //Características Producto
/* Fin Repetitivo

/*FORMAS DE PAG

$pdf->SetLineWidth(0.5);
$pdf->Rect(10, 193, 120, 18);
$pdf->SetLineWidth(0.3);
$pdf->Line(10, 201, 130, 201); //Linea horizontal
// Titulo
$pdf->SetFont('ZagRegular','B',12);
$pdf->SetTextColor(0,0,0); //negro
$pdf->Text(12,198,utf8_decode('Forma de Pago:'));
$pdf->Rect(40, 195, 4, 4); //CONTADO 
//$pdf->Rect(41, 206, 2, 2, 'DF'); //SELECCIONADO: CONTADO
$pdf->Rect(70, 195, 4, 4); //CREDITO
$pdf->Rect(71, 196, 2, 2, 'DF'); //SELECCIONADO: CREDITO
$pdf->Rect(100, 195, 4, 4); //OTROS
//$pdf->Rect(101, 206, 2, 2, 'DF'); //SELECCIONADO: OTROS
//Valores
$pdf->SetFont('Segoe UI','',9);
$pdf->Text(46,198,utf8_decode('CONTADO'));
$pdf->Text(76,198,utf8_decode('CREDITO'));
$pdf->Text(106,198,utf8_decode('OTROS'));
$pdf->SetXY(12,202);
$detalleFormaPago = 'Cancela con cheque postfechado al 05/MARZO/2016. Cancela con cheque postfechado al 05/MARZO/2016.';
$pdf->MultiCell(115, 4, $detalleFormaPago,0);

/* SON
$pdf->SetLineWidth(0.5);
$pdf->Rect(10, 214, 120, 16);
$pdf->SetFont('ZagRegular','B',12);
$pdf->Text(12,219,utf8_decode('Son:'));
$pdf->SetFont('Segoe UI','',9);
$pdf->SetXY(12,221);
$valorLetras = 'NOVECIENTOS CUARENTA Y OCHO CON 99/100 DOLARES AMERICANOS. NOVECIENTOS CUARENTA Y OCHO CON 99/100 DOLARES AMERICANOS';
$pdf->MultiCell(115, 4, $valorLetras,0);

/* GARANTIAS
$pdf->SetLineWidth(0.5);
$pdf->Rect(10, 233, 190, 16);
$pdf->SetFont('ZagRegular','B',12);
$pdf->Text(12,238,utf8_decode('Términos, condiciones y garantías:'));
$pdf->SetFont('Segoe UI','',9);
$garantias = 'Cotización válida por 15 días. Cotización válida por 15 días. Cotización válida por 15 días. Cotización válida por 15 días. Cotización válida por 15 días.';
$pdf->SetXY(12,240);
$pdf->MultiCell(186, 4, utf8_decode($garantias),0);

/* TOTALES
$pdf->SetLineWidth(0.5);
$pdf->Rect(133, 193, 67, 37);
$pdf->Line(174, 193, 174, 230); //Linea Valores
$pdf->SetFont('ZagRegular','B',13);
$pdf->SetTextColor(0,0,0); //negro
$pdf->Text(136,199,utf8_decode('Suman:'));
$pdf->Text(136,205,utf8_decode('Descuento 0%:'));
$pdf->Text(136,211,utf8_decode('Subtotal:'));
$pdf->Text(136,217,utf8_decode('Tarifa IVA 12%:'));
$pdf->SetFont('ZagRegular','B',14);
$pdf->Text(136,225,utf8_decode('TOTAL A FACTURAR:'));
$pdf->SetFont('Segoe UI','',12);
$valor = '123.45';
$pdf->SetXY(180,196);
$pdf->Cell(18, 3, utf8_decode($valor),0,0,'R',0,0); //SUMAN
$pdf->SetXY(180,202);
$pdf->Cell(18, 3, utf8_decode($valor),0,0,'R',0,0); //DESCUENTO
$pdf->SetXY(180,208);
$pdf->Cell(18, 3, utf8_decode($valor),0,0,'R',0,0); //SUBTOTAL
$pdf->SetXY(180,214);
$pdf->Cell(18, 3, utf8_decode($valor),0,0,'R',0,0); //IVA
$pdf->SetFont('Segoe UI','B',13);
$pdf->SetXY(180,222);
$pdf->Cell(18, 3, utf8_decode($valor),0,0,'R',0,0); //TOTAL A FACTURAR
/* FIRMAS

$pdf->SetFont('ZagRegular','B',12);
$pdf->SetXY(35, 265);
$pdf->Cell(50, 3, utf8_decode($vendedor),0,0,'C',0,0);
$pdf->SetXY(35, 269);
$pdf->Cell(50, 3, utf8_decode($cargo),0,0,'C',0,0);
$pdf->SetXY(130, 265);
$pdf->Cell(50, 3, utf8_decode('Acepto Conforme'),0,0,'C',0,0);
$pdf->SetXY(130, 269);
$pdf->Cell(50, 3, utf8_decode('CLIENTE'),0,0,'C',0,0);
//$pdf->Text(45-(strlen($vendedor)/4),269,utf8_decode($cargo));
//$result = 0;
/*
if(strlen($cargo)>strlen($vendedor)){
   $result = (strlen($cargo)-strlen($vendedor));
   $pdf->Text(45+($result*1.5),265,utf8_decode($vendedor));
   $pdf->Text(45,269,utf8_decode($cargo));
}
else{
   $result = (strlen($vendedor)-(strlen($cargo)));
   $pdf->Text(45-(($result-2)/3),265,utf8_decode($vendedor));
   $pdf->Text(45,269,utf8_decode($cargo));
}
//$pdf->Text(144,269,utf8_decode('EL CLIENTE'));
*/

// Salida Final del Documentn
$pdf->Output('I',$nombrePDF);
?>