<?php
/*
* 2007-2013 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2013 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_'))
	exit;

class blockleopermanentlinks extends Module
{
	public function __construct()
	{
		$this->name = 'blockleopermanentlinks';
		$this->tab = 'front_office_features';
		$this->version = 1.0;
		$this->author = 'leotheme';
		$this->need_instance = 0;

		parent::__construct();
		
		$this->displayName = $this->l('Leo Permanent  Footer links block');
		$this->description = $this->l('Adds a block that displays permanent links such as sitemap, contact, etc... by LeoTheme');
	}

	public function install()
	{
			return (parent::install() && $this->registerHook('displayFootNav') && $this->registerHook('header'));
	}

	/**
	* Returns module content for header
	*
	* @param array $params Parameters
	* @return string Content
	*/
	function hooktop($params){		
		return $this->processHook( $params,"top");
	}
	
	function hookfooter($params){		
		return $this->processHook( $params,"footer");
	}
	function hookDisplaySlideshow($params){ 		
		return $this->processHook( $params,"slideshow");
	}
	function hookDisplayPromoteTop($params){ 		
		return $this->processHook( $params,"ptop");
	}
	function hookDisplayBottom($params){ 		
		return $this->processHook( $params,"bottom");
	}
	function hookDisplayContentBottom($params){ 		
		return $this->processHook( $params,"cbottom");
	}
	function hookDisplayFootNav($params){ 		
		return $this->processHook( $params,"footnav");
	}
	function processHook($pparams, $pos="home"){		
		return $this->display(__FILE__, 'blockleopermanentlinks.tpl', $this->getCacheId('blockleopermanentlinks'));		
	}	
	public function hookHeader($params)
	{
		$this->context->controller->addCSS(($this->_path).'blockleopermanentlinks.css', 'all');
	}
}


