{*
* 2007-2013 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2013 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

{include file="$tpl_dir./errors.tpl"}

{if isset($category)}
	{if $category->id AND $category->active}
		<h1>
			{strip}
				{$category->name|escape:'htmlall':'UTF-8'}
				{if isset($categoryNameComplement)}
					{$categoryNameComplement|escape:'htmlall':'UTF-8'}
				{/if}
			{/strip}
			<div class="resumecat category-product-count">
				{include file="$tpl_dir./category-count.tpl"}
			</div>
		</h1>
	
		{if $scenes || $category->description || $category->id_image}
		<div class="content_scene_cat">
			{if $scenes}
				<!-- Scenes -->
				{include file="$tpl_dir./scenes.tpl" scenes=$scenes}
			{else}
				<!-- Category image -->
				{if $category->id_image}
				<div class="align_center">
					<img src="{$link->getCatImageLink($category->link_rewrite, $category->id_image, 'category_default')|escape:'html'}" alt="{$category->name|escape:'htmlall':'UTF-8'}" title="{$category->name|escape:'htmlall':'UTF-8'}" id="categoryImage"  />
				</div>
				{/if}
			{/if}

			{if $category->description}
				<div class="cat_desc">
				{if strlen($category->description) > 150}
					<div id="category_description_short">{$category->description|truncate:150}</div>
					<div id="category_description_full" style="display:none">{$category->description}</div>
					<a href="#" onclick="$('#category_description_short').hide(); $('#category_description_full').show(); $(this).hide(); return false;" class="lnk_more">{l s='More'}</a>
				{else}
					<div>{$category->description}</div>
				{/if}
				</div>
			{/if}
		</div>
		{/if}
		{if isset($subcategories)}
		<!-- Subcategories -->
		<div id="subcategories">
			<h3 class="title_subcategory">{l s='Subcategories'}</h3>
			<div class="inline_list block_content">
				{foreach from=$subcategories item=subcategory name=subcategories}
					{if $subcategory@iteration%4==1}
					<div class="row-fluid">
					{/if}					
						<div class="span3">
							<div class="category-container">
								<a href="{$link->getCategoryLink($subcategory.id_category, $subcategory.link_rewrite)|escape:'htmlall':'UTF-8'}" title="{$subcategory.name|escape:'htmlall':'UTF-8'}" class="img">
									{if $subcategory.id_image}
									<img src="{$link->getCatImageLink($subcategory.link_rewrite, $subcategory.id_image, 'home_default')|escape:'html'}" alt=""  />
									{else}
									<img src="{$img_cat_dir}default-home_default.jpg" alt="" />
									{/if}
								</a>
								<h3 class="s_title_block"><a href="{$link->getCategoryLink($subcategory.id_category, $subcategory.link_rewrite)|escape:'htmlall':'UTF-8'}" class="cat_name ">{$subcategory.name|escape:'htmlall':'UTF-8'}</a></h3>
								<!-- {if $subcategory.description}
									<p class="cat_desc">{$subcategory.description|escape|truncate:60:'...':true}</p>
								{/if} -->
							</div>
						</div>
					{if $subcategory@iteration%4==0||$smarty.foreach.subcategories.last}
					</div>
					{/if}
				{/foreach}
			</div>
			<br class="clear"/>
		</div>
		{/if}

	<div class="wrapper">	
		{if $products}
			<div class="content_sortPagiBar well-large">					
				<div class="row-fluid  sortPagiBar">
					<div class="span6 hidden-phone">
						<div class="inner">
							{include file="./product-sort.tpl"}
						</div>
					</div>
					<div class="span3 hidden-phone">
						<div class="inner">
						  <div class="btn-group" id="productsview">
							<a class="btn" href="#" rel="view-grid"><i class="icon-th" ></i></a>
							<a class="btn" href="#"  rel="view-list"><i class="icon-th-list"></i></a>
						  </div>
						</div>
					</div>
					 <div class="span3">
						<div class="inner pull-right">
							{include file="./product-compare.tpl"}
						</div>
					</div>
				</div>
			</div>
			{include file="./product-list.tpl" products=$products}
			<div class="content_sortPagiBar well-large">					
				<div class="row-fluid sortPagiBar ">
					<div class="span8">
						<div class="inner">
							{include file="./pagination.tpl" paginationId='bottom'}
						</div>
					</div>						
					 <div class="span4 hidden-phone">
						<div class="inner pull-right">
							{include file="./product-compare.tpl" paginationId='bottom'}
						</div>
					</div>
				</div>
			</div>
		{/if}
		{elseif $category->id}
			<p class="warning">{l s='This category is currently unavailable.'}</p>	
		{/if}
		<br class="clear" />
	</div>
{/if}
