{*
* 2007-2013 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2013 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

{capture name=path}{l s='Contact'}{/capture}

<h1>{l s='Customer service'} - {if isset($customerThread) && $customerThread}{l s='Your reply'}{else}{l s='Contact us'}{/if}</h1>

{if isset($confirmation)}
	<p>{l s='Your message has been successfully sent to our team.'}</p>
	<ul class="footer_links">
		<li><a href="{$base_dir}"><img class="icon" alt="" src="{$img_dir}icon/home.gif"/></a><a href="{$base_dir}">{l s='Home'}</a></li>
	</ul>
{elseif isset($alreadySent)}
	<p>{l s='Your message has already been sent.'}</p>
	<ul class="footer_links">
		<li><a href="{$base_dir}"><img class="icon" alt="" src="{$img_dir}icon/home.gif"/></a><a href="{$base_dir}">{l s='Home'}</a></li>
	</ul>
{else}
	<p class="bold">{l s='For questions about an order or for more information about our products'}.</p>
	{include file="$tpl_dir./errors.tpl"}
		<form action="{$request_uri|escape:'htmlall':'UTF-8'}" method="post" class="std  form-horizontal" enctype="multipart/form-data">
		<fieldset>
			<h3>{l s='send a message'}</h3>
				<div class="control-group select">
					<label class="control-label" for="id_contact">{l s='Subject Heading'}</label>
					<div class="controls">
						{if isset($customerThread.id_contact)}
								{foreach from=$contacts item=contact}
									{if $contact.id_contact == $customerThread.id_contact}
										<input type="text" class="input-xlarge" id="contact_name" name="contact_name" value="{$contact.name|escape:'htmlall':'UTF-8'}" readonly="readonly" />
										<input type="hidden" name="id_contact" value="{$contact.id_contact}" />
									{/if}
								{/foreach}
						</div>
						{else}
							<select id="id_contact" name="id_contact" class="input-xlarge" onchange="showElemFromSelect('id_contact', 'desc_contact')">
								<option value="0">{l s='-- Choose --'}</option>
							{foreach from=$contacts item=contact}
								<option value="{$contact.id_contact|intval}" {if isset($smarty.post.id_contact) && $smarty.post.id_contact == $contact.id_contact}selected="selected"{/if}>{$contact.name|escape:'htmlall':'UTF-8'}</option>
							{/foreach}
							</select>
						</div>
						<!-- <p id="desc_contact0" class="desc_contact">&nbsp;</p> -->
							{foreach from=$contacts item=contact}
								<p id="desc_contact{$contact.id_contact|intval}" class="desc_contact" style="display:none;">
									{$contact.description|escape:'htmlall':'UTF-8'}
								</p>
							{/foreach}
						{/if}
				</div>
				<div class="control-group">
					<label class="control-label" for="email">{l s='Email address'}</label>
					<div class="controls">
						{if isset($customerThread.email)}
							<input type="text" class="input-xlarge" id="email" name="from" value="{$customerThread.email|escape:'htmlall':'UTF-8'}" readonly="readonly" />
						{else}
							<input type="text" class="input-xlarge" id="email" name="from" value="{$email|escape:'htmlall':'UTF-8'}" />
						{/if}
					</div>
				</div>
			{if !$PS_CATALOG_MODE}
				{if (!isset($customerThread.id_order) || $customerThread.id_order > 0)}
				<div class="control-group text select">
					<label class="control-label" for="id_order">{l s='Order Reference'}</label>
					<div class="controls">
						{if !isset($customerThread.id_order) && isset($isLogged) && $isLogged == 1}
							<select name="id_order" class="input-xlarge">
								<option value="0">{l s='-- Choose --'}</option>
								{foreach from=$orderList item=order}
									<option value="{$order.value|intval}" {if $order.selected|intval}selected="selected"{/if}>{$order.label|escape:'htmlall':'UTF-8'}</option>
								{/foreach}
							</select>
						{elseif !isset($customerThread.id_order) && !isset($isLogged)}
					<input type="text" class="input-xlarge" name="id_order" id="id_order" value="{if isset($customerThread.id_order) && $customerThread.id_order|intval > 0}{$customerThread.id_order|intval}{else}{if isset($smarty.post.id_order) && !empty($smarty.post.id_order)}{$smarty.post.id_order|intval}{/if}{/if}" />
						{elseif $customerThread.id_order > 0}
							<input type="text" class="input-xlarge" name="id_order" id="id_order" value="{$customerThread.id_order|intval}" readonly="readonly" />
						{/if}
					</div>
				</div>
				{/if}
				{if isset($isLogged) && $isLogged}
				<div class="control-group text select">
					<label class="control-label"  for="id_product">{l s='Product'}</label>
					<div class="controls">
						{if !isset($customerThread.id_product)}
						{foreach from=$orderedProductList key=id_order item=products name=products}
							<select name="id_product" id="{$id_order}_order_products" class="input-xlarge product_select" style="{if !$smarty.foreach.products.first} display:none; {/if}" {if !$smarty.foreach.products.first}disabled="disabled" {/if}>
								<option value="0">{l s='-- Choose --'}</option>
								{foreach from=$products item=product}
									<option value="{$product.value|intval}">{$product.label|escape:'htmlall':'UTF-8'}</option>
								{/foreach}
							</select>
						{/foreach}
						{elseif $customerThread.id_product > 0}
							<input type="text" class="input-xlarge" name="id_product" id="id_product" value="{$customerThread.id_product|intval}" readonly="readonly" />
						{/if}
					</div>
				</div>
				{/if}
			{/if}
			{if $fileupload == 1}
				<div class="control-group text">
					<label class="control-label" for="fileUpload">{l s='Attach File'}</label>
					<div class="controls">
						<input type="hidden" name="MAX_FILE_SIZE" value="2000000" />
						<input class="input-xlarge" type="file" name="fileUpload" id="fileUpload" />
					</div>
				</div>
			{/if}
			<div class="control-group textarea">
				<label class="control-label" for="message">{l s='Message'}</label>
				<div class="controls textarea">
				 <textarea id="message" class="input-xlarge" name="message" rows="5" cols="11">{if isset($message)}{$message|escape:'htmlall':'UTF-8'|stripslashes}{/if}</textarea>
				</div>
			</div>
			<div class="control-group submit">
				<div class="controls">
					<input type="submit" name="submitMessage" id="submitMessage" value="{l s='Send'}" class="button_large" />
				</div>
			</div>
	</fieldset>
</form>
{/if}
