{*
* 2007-2013 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2013 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<!--[if lt IE 7]> <html class="no-js lt-ie9 lt-ie8 lt-ie7 " lang="{$lang_iso}"> <![endif]-->
<!--[if IE 7]><html class="no-js lt-ie9 lt-ie8 ie7" lang="{$lang_iso}"> <![endif]-->
<!--[if IE 8]><html class="no-js lt-ie9 ie8" lang="{$lang_iso}"> <![endif]-->
<!--[if gt IE 8]> <html class="no-js ie9" lang="{$lang_iso}"> <![endif]-->
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="{$lang_iso}">
	<head>
		<title>{$meta_title|escape:'htmlall':'UTF-8'}</title>
{if isset($meta_description) AND $meta_description}
		<meta name="description" content="{$meta_description|escape:html:'UTF-8'}" />
{/if}
{if isset($meta_keywords) AND $meta_keywords}
		<meta name="keywords" content="{$meta_keywords|escape:html:'UTF-8'}" />
{/if}
		<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=utf-8" />
		<meta http-equiv="content-language" content="{$meta_language}" />
		<meta name="generator" content="PrestaShop" />
		<meta name="robots" content="{if isset($nobots)}no{/if}index,{if isset($nofollow) && $nofollow}no{/if}follow" />
		<!-- Mobile Specific Metas ================================================== -->
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
		<link rel="icon" type="image/vnd.microsoft.icon" href="{$favicon_url}?{$img_update_time}" />
		<link rel="shortcut icon" type="image/x-icon" href="{$favicon_url}?{$img_update_time}" />
		<script type="text/javascript">
			var baseDir = '{$content_dir|addslashes}';
			var baseUri = '{$base_uri|addslashes}';
			var static_token = '{$static_token|addslashes}';
			var token = '{$token|addslashes}';
			var priceDisplayPrecision = {$priceDisplayPrecision*$currency->decimals};
			var priceDisplayMethod = {$priceDisplay};
			var roundMode = {$roundMode};
		</script>

<link rel="stylesheet" type="text/css" href="{$BOOTSTRAP_CSS_URI}"/>		
{if isset($css_files)}
	{foreach from=$css_files key=css_uri item=media}
	<link href="{$css_uri}" rel="stylesheet" type="text/css" media="{$media}" />
	{/foreach}
{/if}

{if $LEO_SKIN_DEFAULT &&  $LEO_SKIN_DEFAULT !="default"}
	<link rel="stylesheet" type="text/css" href="{$content_dir}themes/{$LEO_THEMENAME}/skins/{$LEO_SKIN_DEFAULT}/css/skin.css"/>
{/if}
 	
{if $LEO_RESPONSIVE}
	<link rel="stylesheet" type="text/css" href="{$content_dir}themes/{$LEO_THEMENAME}/css/theme-responsive.css"/>
	<link rel="stylesheet" type="text/css" href="{$BOOTSTRAP_RESPONSIVECSS_URI}"/>
{/if}
{$LEO_CUSTOMWIDTH}
{if isset($js_files)}
	{foreach from=$js_files item=js_uri}
	<script type="text/javascript" src="{$js_uri}"></script>
	{/foreach}
{/if}
{if !$LEO_CUSTOMFONT}
	<link href='http://fonts.googleapis.com/css?family=Arbutus+Slab' rel='stylesheet' type='text/css'>
{/if}
<script type="text/javascript" src="{$content_dir}themes/{$LEO_THEMENAME}/js/custom.js"></script>

{if $hide_left_column||in_array($page_name,array('index'))}{$HOOK_LEFT_COLUMN=null}{/if}
{if $hide_right_column||in_array($page_name,array('index'))}{$HOOK_RIGHT_COLUMN=null}{/if}

<!--[if lt IE 9]>
<script src="https://html5shim.googlecode.com/svn/trunk/html5.js"></script>
<![endif]-->

	{$HOOK_HEADER}
	</head>
	<body {if isset($page_name)}id="{$page_name|escape:'htmlall':'UTF-8'}"{/if} class="{$LEO_BGPATTERN} fs{$FONT_SIZE}">
	{if !$content_only}
		{if isset($restricted_country_mode) && $restricted_country_mode}
		<div id="restricted-country">
			<p>{l s='You cannot place a new order from your country.'} <span class="bold">{$geolocation_country}</span></p>
		</div>
		{/if}
		<div id="page" class="clearfix">
			
			<!-- Header -->
			<header id="header"  class="{if $page_name == index}{if !empty($HOOK_SLIDESHOW)} suffix_home {else} bg_gray {/if} {else} bg_brown {/if}">					
					<section class="header">
						<div class="container" >
							<div class="row-fluid">
								<div class="header-left pull-left">							
										<a id="header_logo" href="{$base_dir}" title="{$shop_name|escape:'htmlall':'UTF-8'}">
											<img class="logo" src="{$logo_url}" alt="{$shop_name|escape:'htmlall':'UTF-8'}" {if $logo_image_width}width="{$logo_image_width}"{/if} {if $logo_image_height}height="{$logo_image_height}" {/if} />
										</a>				
										{if !empty($HOOK_HEADERRIGHT)}
										<div id="header_right" class="">
											{$HOOK_HEADERRIGHT}	
										</div>
										{/if}
								</div>
								<div class="header-right">
									<section class="topbar">
										<div class="row-fluid">						
												{$HOOK_TOP}	
										</div>
									</section>
									{if !empty($HOOK_TOPNAVIGATION) }
									<nav id="topnavigation">
										<div class="row-fluid">
											 {$HOOK_TOPNAVIGATION}
										</div>
									</nav>
									{/if}
								</div>
							</div>
						</div>
					</section>	
			</header>
			
			{if $HOOK_SLIDESHOW}
				<section id="slideshow"  class="{if $page_name == index}bg_gray{else}bg_brown{/if}">
					<div class="main_silde">	
							<div class="row-fluid">
								 {$HOOK_SLIDESHOW}
							</div>
					</div>
				</section>
			{/if}
			
			{if $HOOK_PROMOTETOP}
			<section id="promotetop" class="{if $page_name == index}bg_gray{else}bg_brown{/if}">
				<div class="main_promotetop">
					<div class="container bg_pink">
						<div class="row-fluid">
							 {$HOOK_PROMOTETOP}
						</div>
					</div>
				</div>
			</section>
			{/if}
			
			{if $page_name != index}
			<section class="leo-breadscrumb">
				<div class="container bg_white">
					{include file="$tpl_dir./breadcrumb.tpl"}
				</div>
			</section>
			{/if}
			
			<section id="columns" class="clearfix">
				<div class="container bg_white">
					<div class="row-fluid">
						{include file="$tpl_dir./layout/{$LEO_LAYOUT_DIRECTION}/header.tpl" hide_left_column=$hide_left_column hide_right_column=$hide_right_column }
	{/if}
